// ################################################################################
//
//  Button Switch Test vB0
//
//  Released:  09/01/2025
//
//  Author: TechKnowTone
//
// ################################################################################
/*
    TERMS OF USE: This software is furnished "as is", without technical support, and
    with no warranty, expressed or implied, as to its usefulness for any purpose. In
    no event shall the author or copyright holder be liable for any claim, damages,
    or other liability, whether in an action of contract, tort or otherwise, arising
    from, out of or in connection with the software or the use or other dealings in
    the software.

    microcontroller: ESP32 Dev Module   v3.1.0

    This code was writtent to confirm the function of the two button switches, SW0
    and SW1. It outputs their status to the serial port.
    
    IMPORTANT - Espressif changed the way ESP-NOW works from v3.0, which broke the original
    code and caused compiler errors. This version has been modified to work with v3.0+.
    Enjoy!
*/
// Declare libraries

#define Released "09/01/2025"

// define constants
#define SW0_Pin 12                  // GPIO for switch SW0
#define SW1_Pin 15                  // GPIO for switch SW1

// Declare and initialise general global variables
bool SW0_Last = HIGH;         // previous state of SW0
bool SW0_State = HIGH;        // state read by the code
bool SW1_Last = HIGH;         // previous state of SW0
bool SW1_State = HIGH;        // state read by the code

// --------------------------------------------------------------------------------

void setup() {
  // Setup basic functions
  pinMode(SW0_Pin,INPUT_PULLUP);
  pinMode(SW1_Pin,INPUT_PULLUP);

  Serial.begin(115200); // use this baud rate
  Serial.println("Omni-Bot");
  Serial.println("Button Switch Test");
  Serial.println("");
  delay(20);
}

// --------------------------------------------------------------------------------

void loop() {
  // This main loop runs continuously, on a ~4 second cycle
  SW0_State = digitalRead(SW0_Pin);
  if (SW0_State != SW0_Last) {
    if (SW0_State) {Serial.println("SW0 Hi");} else {Serial.println("SW0 Lo");}
  }
  SW0_Last = SW0_State;

  SW1_State = digitalRead(SW1_Pin);
  if (SW1_State != SW1_Last) {
    if (SW1_State) {Serial.println("SW1 Hi");} else {Serial.println("SW1 Lo");}
  }
  SW1_Last = SW1_State;
  delay (20);
}

// --------------------------------------------------------------------------------
